/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;

public class MosPLoginVo extends MosPVo {

	private static final long serialVersionUID = 6894537706885655091L;

	// JSt@C
	private static final String RETURN_URL = "/jsp/common/login.jsp";
	private static final String EXTRA_CSS  = "/pub/common/css/login.css";
	private static final String EXTRA_JS   = "/pub/common/js/login.js";

	// p[^
	public static final String PRM_TXT_USER_ID = "txtUserId";
	public static final String PRM_TXT_PASS    = "txtPass";

	// tB[h
	private String pass;

	// tB[hyѐ
	public static final String NAM_USER_ID = CommonConst.NAM_USER_ID;
	public static final String NAM_PASS    = CommonConst.NAM_PASSWORD;
	public static final int    LEN_USER_ID = 10;
	public static final int    LEN_PASS    = 32;

	/**
	 * RXgN^
	 */
	public MosPLoginVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
	}

	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		setUserId(request.getParameter(PRM_TXT_USER_ID));
		pass = request.getParameter(PRM_TXT_PASS);
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public boolean validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(getUserId(), NAM_USER_ID, PRM_TXT_USER_ID);
		checkRequired(pass,        NAM_PASS   , PRM_TXT_PASS);
		// ^CvmF
		checkCode(getUserId(), NAM_USER_ID, PRM_TXT_USER_ID);
		checkCode(pass,        NAM_PASS   , PRM_TXT_PASS);
		// 񒷊mF
		checkLength(getUserId(), LEN_USER_ID, NAM_USER_ID, PRM_TXT_USER_ID);
		checkLength(pass       , LEN_PASS   , NAM_PASS   , PRM_TXT_PASS);
		return isValid;
	}

	// ANZT\bh
	public String getPass() { return pass; }
	public void setPass(String pass) { this.pass = pass; }

}
